#version 330
#extension GL_EXT_gpu_shader4 : enable
//Historical textMod02.fsh  by Dr2  
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "Historical Text" by dr2 - 2017
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

#define txFnt iChannel0
#define C(c) _ic = (_nc -- == 0) ? (c) : _ic;

#define _SP    C(0x20)
#define _EXCL  C(0x21)
#define _QUOT  C(0x22)
#define _NUM   C(0x23)
#define _DOLLR C(0x24)
#define _PCENT C(0x25)
#define _AMP   C(0x26)
#define _SQUOT C(0x27)
#define _LPAR  C(0x28)
#define _RPAR  C(0x29)
#define _AST   C(0x2A)
#define _PLUS  C(0x2B)
#define _COMMA C(0x2C)
#define _MINUS C(0x2D)
#define _PER   C(0x2E)
#define _SLASH C(0x2F)
#define _0     C(0x30)
#define _1     C(0x31)
#define _2     C(0x32)
#define _3     C(0x33)
#define _4     C(0x34)
#define _5     C(0x35)
#define _6     C(0x36)
#define _7     C(0x37)
#define _8     C(0x38)
#define _9     C(0x39)
#define _COLON C(0x3A)
#define _SEMI  C(0x3B)
#define _LT    C(0x3C)
#define _EQUAL C(0x3D)
#define _GT    C(0x3E)
#define _QUEST C(0x3F)
#define _AT    C(0x40)
#define _A     C(0x41)
#define _B     C(0x42)
#define _C     C(0x43)
#define _D     C(0x44)
#define _E     C(0x45)
#define _F     C(0x46)
#define _G     C(0x47)
#define _H     C(0x48)
#define _I     C(0x49)
#define _J     C(0x4A)
#define _K     C(0x4B)
#define _L     C(0x4C)
#define _M     C(0x4D)
#define _N     C(0x4E)
#define _O     C(0x4F)
#define _P     C(0x50)
#define _Q     C(0x51)
#define _R     C(0x52)
#define _S     C(0x53)
#define _T     C(0x54)
#define _U     C(0x55)
#define _V     C(0x56)
#define _W     C(0x57)
#define _X     C(0x58)
#define _Y     C(0x59)
#define _Z     C(0x5A)
#define _LSQB  C(0x5B)
#define _BSLSH C(0x5C)
#define _RSQB  C(0x5D)
#define _CARET C(0x5E)
#define _USCOR C(0x5F)
#define _GRAVE C(0x60)
#define _a     C(0x61)
#define _b     C(0x62)
#define _c     C(0x63)
#define _d     C(0x64)
#define _e     C(0x65)
#define _f     C(0x66)
#define _g     C(0x67)
#define _h     C(0x68)
#define _i     C(0x69)
#define _j     C(0x6A)
#define _k     C(0x6B)
#define _l     C(0x6C)
#define _m     C(0x6D)
#define _n     C(0x6E)
#define _o     C(0x6F)
#define _p     C(0x70)
#define _q     C(0x71)
#define _r     C(0x72)
#define _s     C(0x73)
#define _t     C(0x74)
#define _u     C(0x75)
#define _v     C(0x76)
#define _w     C(0x77)
#define _x     C(0x78)
#define _y     C(0x79)
#define _z     C(0x7A)
#define _LBRC  C(0x7B)
#define _VBAR  C(0x7C)
#define _RBRC  C(0x7D)
#define _TILDE C(0x7E)
int GetTxChar (vec2 p);
vec2 Rot2D (vec2 q, float a);

vec3 ltDir;
vec2 qnTex;
float dstFar, txDep;
const float pi = 3.14159;

float FontTexDf (vec2 p)
{
  vec3 tx;
  float d;
  int ic;
  ic = GetTxChar (p);
  if (ic != 0) {
    tx = texture (txFnt, mod ((vec2 (mod (float (ic), 16.),
       15. - floor (float (ic) / 16.)) + fract (p)) * (1. / 16.), 1.)).gba - 0.5;
    qnTex = vec2 (tx.r, - tx.g);
    d = tx.b + 1. / 256.;
  } else d = 1.;
  return d;
}

float ObjRayT (vec3 ro, vec3 rd)
{
  vec3 p;
  vec2 srd, dda, h;
  float dHit, dLim, d;
  srd = 1. - 2. * step (0., rd.xz);
  dda = 1. / (abs (rd.xz) + 0.0001);
  dHit = max ((abs (ro.y) - txDep - 0.02) / (abs (rd.y) + 0.001), 0.);
  dLim = min ((abs (ro.y) + txDep) / (abs (rd.y) + 0.001), dstFar);
  for (int j = 0; j < 160; j ++) {
    p = ro + dHit * rd;
    h = fract (dda * fract (srd * p.xz));
    d = max (FontTexDf (p.xz), abs (p.y) - txDep);
    dHit += min (d, 0.01 + min (h.x, h.y));
    if (d < 0.0001 || dHit > dLim) break;
  }
  if (d >= 0.0001) dHit = dstFar;
  return dHit;
}


vec3 ShowScene (vec3 ro, vec3 rd)
{
  vec3 col, bgCol, vn;
  float dstTxt;
  bgCol = vec3 (0.05);
  dstTxt = ObjRayT (ro, rd);
  if (dstTxt < dstFar) {
    ro += rd * dstTxt;
    col = vec3 (0.7, 0.7, 0.1);
    if (abs (ro.y) < txDep - 0.001) vn = normalize (vec3 (qnTex.x, 0.00001, qnTex.y));
    else {
      vn = vec3 (0., sign (ro.y), 0.);
      col = vec3 (1., 1., 0.);
    }
    col = col * (0.2 + 0.8 * max (dot (ltDir, vn), 0.)) +
       0.5 * pow (max (dot (normalize (ltDir - rd), vn), 0.), 128.);
    col = mix (col, bgCol, pow (min (dstTxt / dstFar, 1.), 5.));
  } else col = bgCol;
  return pow (clamp (col, 0., 1.), vec3 (0.7));
}

//void mainImage (out vec4 fragColor, in vec2 fragCoord)
void main (void)
{
  vec4 mPtr;
  vec3 ro, rd, col;
  vec2 canvas, uv;
  float el, az, tCur;
  canvas = iResolution.xy;
  uv = 7. * gl_FragCoord.xy / canvas - 4.; //
  uv.x *= canvas.x / canvas.y;
  tCur = iTime;
  mPtr = iMouse;
  mPtr.xy = mPtr.xy / canvas - 0.5;
  if (mPtr.z > 0.) {
    az = -0.5 * pi - 3. * pi * mPtr.x;
    el = -1.5 * pi * mPtr.y;
  } else {
    az = -0.5 * pi;
    el = -0.2 * pi;
  }
  rd = normalize (vec3 (uv, 2.));
  ro = vec3 (0.01, 0., -15.);
  ltDir = normalize (vec3 (1., 1., -1.));
  rd.xz = Rot2D (rd.xz, 0.5 * pi + az);
  rd.yz = Rot2D (rd.yz, 0.5 * pi + el);
  ro.xz = Rot2D (ro.xz, 0.5 * pi + az);
  ro.yz = Rot2D (ro.yz, 0.5 * pi + el);
  ltDir.xz = Rot2D (ltDir.xz, 0.5 * pi + az);
  ltDir.yz = Rot2D (ltDir.yz, 0.5 * pi + el);
  ro.z -= 1.5 * tCur;
  ro.x -= 0.5;
  txDep = 0.15;
  dstFar = 100.;
  col = ShowScene (ro, rd);
  gl_FragColor = vec4 (clamp (col, 0., 1.), 1.);
  gl_FragColor.a = length(gl_FragColor.rgb);
}



int GetTxChar (vec2 p)
{
  vec2 fp;
  ivec2 ip;
  float d;
  int _ic, _nc;
  fp = floor (p);
  fp.y = - fp.y;
  fp.y = mod (fp.y, 24.);
  ip = ivec2 (fp);
  ip.x += 13;
  _nc = ip.x;
  _ic = 0;
  if (ip.x >= 0 && ip.x < 28) {
    if (ip.y == 0) {
      _T _w _e _n _t _y  _SP
      _y _e _a _r _s _SP
      _f _r _o _m _SP 
      _n _o _w  _SP
} else if (ip.y == 1) {
      _y _o _u _SP
      _w _i _l _l _SP
      _b _e _SP
      _m _o _r _e _SP
} else if (ip.y == 2) {
      _d _i _s _a _p _p _o _i _n _t _e _d _SP
      _b _y _SP
} else if (ip.y == 3) {
      _t _h _e _SP
      _t _h _i _n _g _s  _SP
      _t _h _a _t _SP
      _y _o _u _SP
} else if (ip.y == 4) {
      _d _i _d _n _GRAVE _t _SP
      _d _o _COMMA _SP
      _t _h _a _n _SP
      _b _y _SP
      _t _h _e _SP
} else if (ip.y == 5) {
      _o _n _e _s _SP
      _y _o _u _SP
      _d _i _d _SP
      _d _o _PER
} else if (ip.y == 8) {
      _S _o _SP
      _t _h _r _o _w _SP
      _o _f _f _SP
      _y _o _u _r _SP
      _t _e _t _h _e _r _s _SP
    } else if (ip.y == 9) {
      _S _a _i _l _SP
      _a _w _a _y _SP
      _f _r _o _m _SP
      _s _a _f _e _SP
      _h _a _r _b _o _r  _COMMA _SP

    } else if (ip.y == 10) {
      _c _a _t _c _h _SP
      _t _h _e _SP
      _t _r _a _d _e _SP
      _w _i _n _d _s _SP
    } else if (ip.y == 11) {
      _i _n _SP
      _y _o _u _r _SP
      _s _a _i _l _s _SP
    } else if (ip.y == 12) {
      _SP _QUOT _E _x _p _l _o _r _e _COMMA _SP
      _D _r _e _a _m _COMMA _SP 
      _D _i _s _c _o _v _e _r _QUOT _SP
    } else if (ip.y == 14) {
      _SP _SP _SP _SP _MINUS _SP
      _M _a _r _k _SP
      _T _w _a _i _n _SP
      _MINUS _SP
      

    }
  }
  return _ic;
}

vec2 Rot2D (vec2 q, float a)
{
  return q * cos (a) + q.yx * sin (a) * vec2 (-1., 1.);
}
